CREATE TABLE "cxscgi_counters" (
  "date" TEXT NOT NULL,
  "scanned_files" INTEGER DEFAULT '0',
  "scanned_dirs" INTEGER DEFAULT '0',
  "suspicious" INTEGER DEFAULT '0',
  "exploits" INTEGER DEFAULT '0',
  "viruses" INTEGER DEFAULT '0',
  "old_scripts" INTEGER DEFAULT '0',
  "quarantined" INTEGER DEFAULT '0',
  "deleted" INTEGER DEFAULT '0',
  "size" INTEGER DEFAULT '0',
  UNIQUE(date)
);
CREATE TABLE "cxsftp_counters" (
  "date" TEXT NOT NULL,
  "scanned_files" INTEGER DEFAULT '0',
  "scanned_dirs" INTEGER DEFAULT '0',
  "suspicious" INTEGER DEFAULT '0',
  "exploits" INTEGER DEFAULT '0',
  "viruses" INTEGER DEFAULT '0',
  "old_scripts" INTEGER DEFAULT '0',
  "quarantined" INTEGER DEFAULT '0',
  "deleted" INTEGER DEFAULT '0',
  "size" INTEGER DEFAULT '0',
  UNIQUE(date)
);
CREATE TABLE "cxsscan_counters" (
  "date" TEXT NOT NULL,
  "scanned_files" INTEGER DEFAULT '0',
  "scanned_dirs" INTEGER DEFAULT '0',
  "suspicious" INTEGER DEFAULT '0',
  "exploits" INTEGER DEFAULT '0',
  "viruses" INTEGER DEFAULT '0',
  "old_scripts" INTEGER DEFAULT '0',
  "quarantined" INTEGER DEFAULT '0',
  "deleted" INTEGER DEFAULT '0',
  "size" INTEGER DEFAULT '0',
  UNIQUE(date)
);
CREATE TABLE "cxswatch_counters" (
  "date" TEXT NOT NULL,
  "scanned_files" INTEGER DEFAULT '0',
  "scanned_dirs" INTEGER DEFAULT '0',
  "suspicious" INTEGER DEFAULT '0',
  "exploits" INTEGER DEFAULT '0',
  "viruses" INTEGER DEFAULT '0',
  "old_scripts" INTEGER DEFAULT '0',
  "quarantined" INTEGER DEFAULT '0',
  "deleted" INTEGER DEFAULT '0',
  "size" INTEGER DEFAULT '0',
  UNIQUE(date)
);
CREATE TABLE "files" (
  "id" INTEGER PRIMARY KEY,
  "timestamp" TEXT NOT NULL,
  "status" TEXT,
  "stype" TEXT,
  "ftype" TEXT,
  "qfile" TEXT,
  "quid" TEXT,
  "qgid" TEXT,
  "qmode" TEXT,
  "quser" TEXT,
  "qgroup" TEXT,
  "qatime" TEXT,
  "qctime" TEXT,
  "qmtime" TEXT,
  "actfile" TEXT,
  "message" TEXT,
  "cgiuser" TEXT,
  "scriptowner" TEXT,
  "scriptname" TEXT,
  "remoteip" TEXT,
  "url" TEXT,
  "referer" TEXT,
  "uploaduid" TEXT,
  "uploadvuser" TEXT,
  "uploadip" TEXT,
  "md5sum" TEXT,
  "cmd" TEXT,
  "size" INTEGER
);
CREATE TABLE "reports" (
  "id" INTEGER PRIMARY KEY,
  "timestamp" TEXT NOT NULL ,
  "title" TEXT,
  "dbreport" TEXT
);
CREATE INDEX "cxscgi_counters_timestamp_idx" ON "cxscgi_counters" ("date");
CREATE INDEX "cxsftp_counters_timestamp_idx" ON "cxsftp_counters" ("date");
CREATE INDEX "cxsscan_counters_timestamp_idx" ON "cxsscan_counters" ("date");
CREATE INDEX "cxswatch_counters_timestamp_idx" ON "cxswatch_counters" ("date");
CREATE INDEX "files_timestamp_idx" ON "files" ("timestamp");
CREATE INDEX "reports_timestamp_idx" ON "reports" ("timestamp");
