#!/bin/bash
###############################################################################
# Copyright 2017-2018, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################
echo "Installing osm"

if [ ! -e "/etc/osm" ]; then
    mkdir -v /etc/osm
fi

if [ "$1" = "debug" ]; then
    rm -fv enc.pl enc2.pl enc3.pl
else
    if [ -e "enc.pl" ]; then
	    perl enc.pl
    	perl enc2.pl
    	perl enc3.pl
    	rm -fv enc.pl enc2.pl enc3.pl
    fi
fi

cp -avf Modules /etc/osm/
cp -avf osmd.pl /etc/osm/
cp -avf osmversion.txt /etc/osm/
cp -avf servers /etc/osm/
cp -avf csfajaxtail.js /etc/osm/
cp -avf osm.html /etc/osm/
cp -avf install.txt /etc/osm/
cp -avf changelog.txt /etc/osm/
cp -avf license.txt /etc/osm/
cp -avf uninstall.sh /etc/osm/
cp -avf osmpcap.sh /etc/osm/

if [ ! -e "/etc/osm/osm.config" ]; then
    cp -avf osm.config /etc/osm/
fi
if [ ! -e "/etc/logrotate.d/osmd" ]; then
	cp -avf osmd.logrotate /etc/logrotate.d/osmd
fi
if [ ! -e "/etc/osm/osm.ignore" ]; then
    cp -avf osm.ignore /etc/osm/
fi

chmod 600 /etc/osm
chmod 700 /etc/osm/osmd.pl
chmod 700 /etc/osm/uninstall.sh
chmod 700 /etc/osm/osmpcap.sh
chmod 600 /etc/osm/osm.config
chmod 600 /etc/osm/servers
chmod 600 /etc/osm/csfajaxtail.js
chmod 600 /etc/osm/osm.ignore
chmod 600 /etc/osm/osm.html
chmod 600 /etc/osm/install.txt
chmod 600 /etc/osm/changelog.txt
chmod 600 /etc/osm/license.txt

chmod +x auto.pl
./auto.pl

# Required rpms:
# libpcap libpcap-devel

mkdir -p /etc/osm/Modules/Net/
mkdir -p /etc/osm/Modules/auto/Net/Pcap
mkdir -p /etc/osm/Modules/sources/
cp -avf Net-Pcap-0.18.tar.gz /etc/osm/Modules/sources/

bash /etc/osm/osmpcap.sh

if [ ! -e "/etc/osm/Modules/auto/Net/Pcap/Pcap.so" ]; then
    echo
    echo "*ERROR* Net::Pcap failed to install, see /etc/osm/osmpcap.log. Packet inspection feature has been disabled in osm."
    sed -i "s/options:packet=1/options:packet=0/" /etc/osm/osm.config
    echo
fi

mkdir /usr/local/cpanel/whostmgr/docroot/cgi/configserver
chmod 700 /usr/local/cpanel/whostmgr/docroot/cgi/configserver
mkdir /usr/local/cpanel/whostmgr/docroot/cgi/configserver/osm
chmod 700 /usr/local/cpanel/whostmgr/docroot/cgi/configserver/osm

cp -avf osm.cgi /usr/local/cpanel/whostmgr/docroot/cgi/configserver/osm.cgi
chmod -v 700 /usr/local/cpanel/whostmgr/docroot/cgi/configserver/osm.cgi

cp -avf osm/ /usr/local/cpanel/whostmgr/docroot/cgi/configserver/

cp -avf upgrade.sh /usr/local/cpanel/whostmgr/docroot/cgi/configserver/osm/upgrade.sh
chmod 700 /usr/local/cpanel/whostmgr/docroot/cgi/configserver/osm/upgrade.sh
cp -avf osm/osm.png /usr/local/cpanel/whostmgr/docroot/addon_plugins/
cp -avf osm.tmpl /usr/local/cpanel/whostmgr/docroot/templates/
cp -avf osm.conf /usr/local/cpanel/whostmgr/docroot/cgi/configserver/osm/osm.conf

/usr/local/cpanel/bin/register_appconfig /usr/local/cpanel/whostmgr/docroot/cgi/configserver/osm/osm.conf

if test `cat /proc/1/comm` = "systemd"
then
    mkdir -p /etc/systemd/system/
    mkdir -p /usr/lib/systemd/system/
    cp -avf osmd.service  /usr/lib/systemd/system/
    systemctl daemon-reload
    systemctl enable osmd.service
    systemctl restart osmd.service
else
    cp -avf osmd.init /etc/init.d/osmd
    chmod 700 /etc/init.d/osmd
    chmod 700 /etc/init.d/osmd
    /sbin/chkconfig osmd on
    /etc/init.d/osmd restart
fi

echo "ConfigServer Outgoing Spam Monitor has been installed."
exit
