#!/usr/local/cpanel/3rdparty/bin/perl
#WHMADDON:cxs:ConfigServer eXploit Scanner
#ACLS:cxs
###############################################################################
# Copyright 2009-2020, Way to the Web Limited
# URL: http://www.configserver.com
# Email: sales@waytotheweb.com
###############################################################################
use strict;
use Fcntl qw(:DEFAULT :flock);
use IPC::Open3;
use CGI::Carp qw(fatalsToBrowser);

use lib '/etc/cxs';
use ConfigServer::cxsUI;

use lib '/usr/local/cpanel';
require Cpanel::Form;
require Cpanel::Config;
require Whostmgr::ACLS;
require Cpanel::Rlimit;
require Cpanel::Template;
require Cpanel::Version::Tiny;
###############################################################################
# start main

our ($script, $script_da, $images, %FORM, $myv, $modalstyle, $SCRIPTOUT,
     %fullsubs, %ajaxsubs);

%FORM = Cpanel::Form::parseform();

Whostmgr::ACLS::init_acls();

if (!Whostmgr::ACLS::hasroot()) {
	print "Content-type: text/html\r\n\r\n";
	print "You do not have access to ConfigServer eXploit Scanner.\n";
	exit();
}

Cpanel::Rlimit::set_rlimit_to_infinity();

$script = "cxs.cgi";
$images = "cxs";

my ($childin, $childout);
my $pid = open3($childin, $childout, $childout, "/usr/sbin/cxs --version");
my @data = <$childout>;
waitpid ($pid, 0);
chomp @data;
if ($data[0] =~ /v(.*)$/) {$myv = $1}

my $bootstrapcss = "<link rel='stylesheet' href='$images/bootstrap/css/bootstrap.min.css'>";
my $jqueryjs = "<script src='$images/jquery.min.js'></script>";
my $bootstrapjs = "<script src='$images/bootstrap/js/bootstrap.min.js'></script>";

my $thisapp = "cxs";
my $reregister;
my $templatehtml;
%ajaxsubs = (
	"cc_body" => 1,
	"cc_dbody" => 1,
	"cc_restore" => 1,
	"cc_report" => 1,
	"cc_showreports" => 1,
	"cc_ignore" => 1,
	"cc_blockip" => 1,
	"cc_delete" => 1,
	"cc_edelete" => 1,
	"tailcmd" => 1,
	"tailscancmd" => 1,
);
%fullsubs = (
	"cc_setup" => 1,
	"cc_setup1" => 1,
	"cc_setup2" => 1,
	"cc_setup3" => 1,
	"cc_setup4" => 1,
	"cc_setup5" => 1,
	"cc_setup6" => 1,
	"cc_delreport" => 1,
	"cc_reports" => 1,
	"cc_stats" => 1,
	"cc_file" => 1,
);
if ($Cpanel::Version::Tiny::major_version >= 65) {
	if (-e "/usr/local/cpanel/whostmgr/docroot/cgi/configserver/${thisapp}/${thisapp}.conf") {
		sysopen (my $CONF, "/usr/local/cpanel/whostmgr/docroot/cgi/configserver/${thisapp}/${thisapp}.conf", O_RDWR | O_CREAT);
		flock ($CONF, LOCK_EX);
		my @confdata = <$CONF>;
		chomp @confdata;
		for (0..scalar(@confdata)) {
			if ($confdata[$_] =~ /^target=mainFrame/) {
				$confdata[$_] = "target=_self";
				$reregister = 1;
			}
		}
		if ($reregister) {
			seek ($CONF, 0, 0);
			truncate ($CONF, 0);
			foreach (@confdata) {
				print $CONF "$_\n";
			}
			system("/usr/local/cpanel/bin/register_appconfig","/usr/local/cpanel/whostmgr/docroot/cgi/configserver/${thisapp}/${thisapp}.conf");
			$reregister = "<div class='bs-callout bs-callout-info'><h4>Updated application. The next time you login to WHM this will open within the native WHM main window instead of launching a separate window</h4></div>\n";
		}
		close ($CONF);
	}
}

if ($FORM{action} eq "cc_body" or $FORM{action} eq "cc_dbody" or $FORM{action} eq "cc_showreports") {
} elsif ($ajaxsubs{$FORM{action}} or $FORM{action} eq "tailcmd" or $FORM{action} eq "tailscancmd") {
	print "content-type: text/plain\n\n";
} else {
	print "Content-type: text/html\r\n\r\n";

	unless ($FORM{action} eq "RunScan" or ($FORM{action} =~ /^cc_/ and !$fullsubs{$FORM{action}} and $FORM{action} !~ /^cc_\w+bulk$/) or $FORM{action} eq "Run Scan" or $FORM{action} eq "viewq" or $FORM{action} eq "tailcmd" or $FORM{action} eq "tailscancmd") {
		open $SCRIPTOUT, '>', \$templatehtml;
		select $SCRIPTOUT;

		print <<EOF;
	<!-- $bootstrapcss -->
	<link href='$images/configserver.css' rel='stylesheet' type='text/css'>
	$jqueryjs
	$bootstrapjs
<style>
pre {
	overflow: initial;
}
</style>
EOF
	} else {
		print <<EOF;
<!doctype html>
<html lang='en'>
<head>
	$bootstrapcss
	<link href='$images/configserver.css' rel='stylesheet' type='text/css'>
	$jqueryjs
	$bootstrapjs
</head>
<body>
<div class='container-fluid'>
<style>
pre {
	overflow: initial;
}
</style>
EOF
	}

	unless ($FORM{action} eq "tailcmd" or $FORM{action} eq "tailscancmd" or $ajaxsubs{$FORM{action}}) {
		print <<EOF;
<div id="loader"></div><br />
<div class='panel panel-default'>
<h4><img src='$images/cxs_small.png' style='padding-left: 10px'> ConfigServer eXploit Scanner - cxs v$myv</h4></div>
EOF
	}
}

ConfigServer::cxsUI::displayUI(\%FORM,\%ajaxsubs,$script,$script_da,$images,$myv);

unless ($ajaxsubs{$FORM{action}}) {
	print <<EOF;
<script>
	\$("#loader").hide();
	\$("#docs-link").hide();
</script>
EOF
	unless ($FORM{action} eq "RunScan" or ($FORM{action} =~ /^cc_/ and !$fullsubs{$FORM{action}} and $FORM{action} !~ /^cc_\w+bulk$/) or $FORM{action} eq "Run Scan" or $FORM{action} eq "viewq" or $FORM{action} eq "tailcmd" or $FORM{action} eq "tailscancmd") {
		close $SCRIPTOUT;
		select STDOUT;
		Cpanel::Template::process_template(
			'whostmgr',
			{
				"template_file" => "${thisapp}.tmpl",
				"${thisapp}_output" => $templatehtml,
				"print"         => 1,
			}
		);
	} else {
		print "</div>\n";
		print "</body>\n";
		print "</html>\n";
	}
}

1;
